package com.bailuntec.api.common;

import com.bailuntec.api.Config;
import feign.Feign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.lang.NonNull;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/14 11:31 上午
 */
public class FeignUtil {

    public static <T> T getInstance(@NonNull Class<T> FeignApiType) {
        Config config = new Config();
        return Feign
                .builder()
                .decoder(config.feignDecoder())
                .contract(new SpringMvcContract())
                .target(FeignApiType, FeignApiType.getAnnotation(FeignClient.class).url());
    }
}
