package com.bailuntec.api.bailuntec.oa;

import com.bailuntec.api.bailuntec.oa.response.ExchangeRate;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/12 2:09 下午
 */
@FeignClient(name = "oa", url = "http://oa.bailuntec.com")
public interface OaApi {

    /**
     * <p>
     * 获取所有oa user
     * </p>
     *
     * @return oa user
     */
    @GetMapping("/api/User/GetAllUser")
    List<OaUserResp> getAllUser();


    /**
     * <p>
     * 获取所有oa部门
     * </p>
     *
     * @return 部门列表
     */
    @GetMapping("/api/user/GetDeparmentList")
    List<OaDepartmentResp> getDeparmentList();


    /**
     * 获取汇率
     *
     * @param fromCur 源币种
     * @param toCur   目标币种
     * @return str 需要手动转换成{@link com.bailuntec.api.bailuntec.oa.response.ExchangeRate}
     * <p>
     * <p>
     * 转换代码
     * <code>
     * String res = oaApi.getExchangeRate("CNY", "CNY");
     * String response = BltResponseUtil.filterColonAndBackslash(res);
     * ExchangeRate exchangeRate = JsonUtilByFsJson.jsonToBean(response, ExchangeRate.class);
     * </code>
     */
    @Deprecated
    @GetMapping("/api/ExchangeRate/GetExchangeRate")
    String getExchangeRate(@RequestParam("fromCur") String fromCur,
                           @RequestParam("toCur") String toCur);

    /**
     * 获取汇率
     *
     * @param fromCur 源币种
     * @param toCur   目标币种
     * @param date    汇率日期
     * @return {@link com.bailuntec.api.bailuntec.oa.response.ExchangeRate}
     */
    @GetMapping("/api/ExchangeRate/GetExchangeRateByCurAndDate")
    ExchangeRate getExchangeRateByCurAndDate(@RequestParam("fromCur") String fromCur,
                                             @RequestParam("toCur") String toCur,
                                             @RequestParam("date")
                                             @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8") LocalDate date);
}
