package com.bailuntec.api.bailuntec.purchase.resp;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class PurchaseDetailDto {

    @JsonProperty("BuyNo")
    @JSONField(name = "BuyNo")
    private String purchaseId;

    @JsonProperty("Status")
    @JSONField(name = "Status")
    private Integer status;

    @JsonProperty("BuyCategoryName")
    @JSONField(name = "BuyCategoryName")
    private String purchaseCategoryName;

    @JsonProperty("SupplierId")
    @JSONField(name = "SupplierId")
    private Integer deliverId;

    @JsonProperty("SupplierName")
    @JSONField(name = "SupplierName")
    private String deliverName;

    @JsonProperty("SupplierValue")
    @JSONField(name = "SupplierValue")
    private Integer deliverValue;

    @JsonProperty("BuyUserName")
    @JSONField(name = "BuyUserName")
    private String buyerName;

    @JSONField(name = "WareHouseFrom")
    @JsonProperty("WareHouseFrom")
    private String warehouseFromCode;

    @JSONField(name = "WareHouseFromName")
    @JsonProperty("WareHouseFromName")
    private String warehouseFromName;

    @JSONField(name = "WareHouseTo")
    @JsonProperty("WareHouseTo")
    private String warehouseIntoCode;

    @JSONField(name = "WareHouseToName")
    @JsonProperty("WareHouseToName")
    private String warehouseIntoName;

    @JsonProperty("SkuCode")
    @JSONField(name = "SkuCode")
    private String bailunSku;

    @JSONField(name = "BuyCount")
    @JsonProperty("BuyCount")
    private Integer quantityPurchase;

    @JSONField(name = "PayPrice")
    @JsonProperty("PayPrice")
    private BigDecimal unitPrice;

    @JSONField(name = "PayAmount")
    @JsonProperty("PayAmount")
    private BigDecimal amountPaid;

    @JSONField(name = "MoneyUnitCode")
    @JsonProperty("MoneyUnitCode")
    private String currencyCode;

    @JSONField(name = "MoneyUnitName")
    @JsonProperty("MoneyUnitName")
    private String currencyName;

    @JSONField(name = "ReturnCount")
    @JsonProperty("ReturnCount")
    private Integer quantityReturn;

    @JSONField(name = "PutinCount")
    @JsonProperty("PutinCount")
    private Integer quantityInbound;

    @JSONField(name = "DeliverCount")
    @JsonProperty("DeliverCount")
    private Integer quantityDeliver;

    @JsonProperty("NotDeliverCount")
    @JSONField(name = "NotDeliverCount")
    private Integer quantityNotDeliver;

    @JsonProperty("ArrivalCount")
    @JSONField(name = "ArrivalCount")
    private Integer quantityArrival;

    @JsonProperty("NotArrivalCount")
    @JSONField(name = "NotArrivalCount")
    private Integer quantityNotArrival;

    @JsonProperty("QcCount")
    @JSONField(name = "QcCount")
    private Integer quantityInspect;

    @JsonProperty("QualifiedCount")
    @JSONField(name = "QualifiedCount")
    private Integer quantityQualifiedInspect;

    @JsonProperty("NotQualifiedCount")
    @JSONField(name = "NotQualifiedCount")
    private Integer quantityUnqualifiedInspect;

    @JsonProperty("AllotCount")
    @JSONField(name = "AllotCount")
    private Integer quantityWaitTransfer;

    @JsonProperty("ExchangeCount")
    @JSONField(name = "ExchangeCount")
    private Integer quantityExchange;

    @JSONField(name = "PutinLoseCount")
    @JsonProperty("PutinLoseCount")
    private Integer quantityLoseInbound;

    @JSONField(name = "CreateTime")
    @JsonProperty("CreateTime")
    private String createTimed;

    @JSONField(name = "UpdateTime")
    @JsonProperty("UpdateTime")
    private String updateTimed;


    @JsonProperty("TaobaoOrderNo")
    @JSONField(name = "TaobaoOrderNo")
    private String alibabaOrderId;

    @JSONField(name = "ExpressNo")
    @JsonProperty("ExpressNo")
    private String logisticsOrderId;

    @JSONField(name = "ExpressCompany")
    @JsonProperty("ExpressCompany")
    private String logisticsCompanyName;

    @JSONField(name = "no")
    @JsonProperty("no")
    private Integer companyId;

    @JSONField(name = "ispush")
    @JsonProperty("ispush")
    private Integer ispush;

    @JSONField(name = "isallot")
    @JsonProperty("isallot")
    private Integer isallot;

    @JSONField(name = "isaims")
    @JsonProperty("isaims")
    private Integer isaims;

    @JSONField(name = "detail_delstatus")
    @JsonProperty("detail_delstatus")
    private Boolean detailDelstatus;

    @JSONField(name = "paytype")
    @JsonProperty("paytype")
    private Integer payType;

    @JSONField(name = "paystatus")
    @JsonProperty("paystatus")
    private Integer payStatus;

    @JSONField(name = "lastsigntime")
    @JsonProperty("lastsigntime")
    private Date lastSigntime;

    @JSONField(name = "arrivalstatus")
    @JsonProperty("BuyarrivalstatusNo")
    private Integer arrivalStatus;

    @JSONField(name = "buyamount")
    @JsonProperty("buyamount")
    private Integer amountBuy;

    @JSONField(name = "buypayamount")
    @JsonProperty("buypayamount")
    private Integer amountPayed;

    @JSONField(name = "expressfee")
    @JsonProperty("expressfee")
    private Integer amountExpress;

    @JSONField(name = "createusername")
    @JsonProperty("createusername")
    private String createusername;

    @JSONField(name = "can_7day_refund")
    @JsonProperty("can_7day_refund")
    private Integer can7dayRefund;

}

