package com.bailuntec.api.bailuntec.oms;

import com.bailuntec.api.bailuntec.oms.response.GetBailunOrdersResp;
import com.bailuntec.api.bailuntec.oms.response.OmsPageResult;
import com.bailuntec.api.bailuntec.oms.response.OmsResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/6 11:48 上午
 */
@FeignClient(name = "omsApi", url = "http://oms.bailuntec.com")
public interface OmsApi {

    /**
     * <p>
     * 同步百伦订单
     * </p>
     *
     * @param BailunLastUpdateTimeFrom 最后更新时间 yyyy-MM-dd HH:mm:ss
     * @param BailunLastUpdateTimeTo   最后更新时间 yyyy-MM-dd HH:mm:ss
     * @param pageCount                page
     * @param pageIndex                page
     * @return 百伦订单
     */
    @GetMapping("/apiV2/bailunOrder/getBailunOrders")
    OmsResult<OmsPageResult<GetBailunOrdersResp>> getBailunOrders(@RequestParam("BailunLastUpdateTimeFrom") String BailunLastUpdateTimeFrom,
                                                                  @RequestParam("BailunLastUpdateTimeTo") String BailunLastUpdateTimeTo,
                                                                  @RequestParam("pageCount") Integer pageCount,
                                                                  @RequestParam("pageIndex") Integer pageIndex);
}
