package com.bailuntec.api.bailuntec.cw;

import com.bailuntec.api.bailuntec.cw.response.GetCashiersResp;
import com.bailuntec.api.bailuntec.cw.response.GetHandleFeeTradeRecordsResp;
import com.bailuntec.api.bailuntec.cw.response.GetRepayPlanDetailsResp;
import com.bailuntec.api.bailuntec.cw.response.GetWithdrawDetailPagesResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 财务系统
 * </p>
 *
 * @author robbendev
 * @since 2020/9/28 4:02 下午
 */
@FeignClient(name = "cw", url = "http://cw.bailuntec.com/", fallback = CwApi.CwApiFallback.class)
public interface CwApi {

    /**
     * 请求流水接口
     *
     * @param rows            记录行数
     * @param BeginModifyTime 最后更新时间begin yyyy-MM-dd HH:mm:ss
     * @param EndModifyTime   最后更新时间end yyyy-MM-dd HH:mm:ss
     * @param Page            页码
     * @return 流水
     */
    @GetMapping("/API/API/getCashiers")
    List<GetCashiersResp> getCashiers(@RequestParam("rows") Integer rows,
                                      @RequestParam("BeginModifyTime") String BeginModifyTime,
                                      @RequestParam("EndModifyTime") String EndModifyTime,
                                      @RequestParam("Page") Integer Page);

    /**
     * 请求流水接口同步百伦接口
     *
     * @param pagesize  分页大小
     * @param begintime 开始时间 yyyy-MM-dd HH:mm:ss
     * @param endtime   结束时间 yyyy-MM-dd HH:mm:ss
     * @param pageindex 页码
     * @return 流水
     */
    @GetMapping("/API/API/GetWithdrawDetailPages")
    GetWithdrawDetailPagesResp getWithdrawDetailPages(@RequestParam("pagesize") Integer pagesize,
                                                      @RequestParam("begintime") String begintime,
                                                      @RequestParam("endtime") String endtime,
                                                      @RequestParam("pageindex") Integer pageindex);

    /**
     * <p>
     * 获取财务手续费
     * </p>
     *
     * @param beginTime 开始时间  yyyy-MM-dd HH:mm:ss
     * @param endTime   结束时间  yyyy-MM-dd HH:mm:ss
     * @return 财务手续费列表
     */
    @GetMapping("/API/API/GetHandleFeeTradeRecords")
    List<GetHandleFeeTradeRecordsResp> getHandleFeeTradeRecords(@RequestParam("beginTime") String beginTime,
                                                                @RequestParam("endTime") String endTime);

    /**
     * <p>请求利息支出接口同步百伦接口</p>
     *
     * @return 利息支出
     */
    @GetMapping("/api/api/GetRepayPlanDetails")
    List<GetRepayPlanDetailsResp> getRepayPlanDetails(@RequestParam("startDate") String startDate,
                                                      @RequestParam("endDate") String endDate);


    @Component
    class CwApiFallback implements CwApi {


        @Override
        public List<GetCashiersResp> getCashiers(Integer rows, String BeginModifyTime, String EndModifyTime, Integer Page) {
            throw new RuntimeException("net work error");
        }

        @Override
        public GetWithdrawDetailPagesResp getWithdrawDetailPages(Integer pagesize, String begintime, String endtime, Integer pageindex) {
            throw new RuntimeException("net work error");
        }

        @Override
        public List<GetHandleFeeTradeRecordsResp> getHandleFeeTradeRecords(String beginTime, String endTime) {
            throw new RuntimeException("net work error");
        }

        @Override
        public List<GetRepayPlanDetailsResp> getRepayPlanDetails(String startDate, String endDate) {
            throw new RuntimeException("net work error");
        }

    }
}
