package com.bailuntec.api.bailuntec.oa;

import com.bailuntec.api.bailuntec.oa.response.ExchangeRate;
import com.bailuntec.api.bailuntec.oa.response.OaDepartmentResp;
import com.bailuntec.api.bailuntec.oa.response.OaUserResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/12 2:09 下午
 */
@FeignClient(name = "oa", url = "oa.bailuntec.com")
public interface OaApi {

    /**
     * <p>
     * 获取所有oa user
     * </p>
     *
     * @return oa user
     */
    @GetMapping("/api/User/GetAllUser")
    List<OaUserResp> getAllUser();


    /**
     * <p>
     * 获取所有oa部门
     * </p>
     *
     * @return 部门列表
     */
    @GetMapping("/api/user/GetDeparmentList")
    List<OaDepartmentResp> getDeparmentList();


    @GetMapping("/api/ExchangeRate/GetExchangeRate")
    String getExchangeRate(@RequestParam("fromCur") String fromCur,
                                 @RequestParam("toCur") String toCur);
}
