package com.bailuntec.api.bailuntec.cw.response;

import com.bailuntec.common.json.DotNetDateFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/28 4:09 下午
 */
@Data
public class GetWithdrawDetailPagesResp {

    private Integer total;
    private List<GetWithdrawDetailPagesItem> list;

    @Data
    public static class GetWithdrawDetailPagesItem {
        private Integer id;

        @JsonProperty("Id")
        private Integer cwId;

        private Integer dataType;

        private String fromAccount;

        private Integer fromCurrency;

        private String exchangeCurrency;

        private BigDecimal exchangeMoney;

        private String toAccount;

        private Integer toCurrency;

        private BigDecimal money;

        private BigDecimal serviceCharge;

        @JsonDeserialize(using = DotNetDateFormat.class)
        private LocalDateTime daozhangTime;

        private BigDecimal daozhangMoney;

        private String confirmName;

        private Integer status;

        private String createName;

        @JsonDeserialize(using = DotNetDateFormat.class)
        private LocalDateTime createtime;

        private String updateName;

        @JsonDeserialize(using = DotNetDateFormat.class)
        private LocalDateTime updateTime;

        private String remark;

        private String fromCurrencyName;

        private String toCurrencyName;

        private Integer collectionPlatform;

        private String bank;

        private Integer saleslPlatform;

        private String salesAccount;

        private BigDecimal otherToCnyExchangeRate;

        private BigDecimal otherToCnyMoney;

        @JsonDeserialize(using = DotNetDateFormat.class)
        private LocalDateTime gmtCreateTime;

        @JsonDeserialize(using = DotNetDateFormat.class)
        private LocalDateTime gmtModifyTime;
    }
}
