package com.bailuntec.api.ebay.seller;

import com.bailuntec.api.ebay.seller.response.transaction.EbayTransactionRes;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-19
 * @Modified by:
 */
@FeignClient(name = "ebayTransactionApi", url = "https://apiz.ebay.com/sell/finances/v1")
public interface EbayTransactionApi {

    @GetMapping("/transaction")
    EbayTransactionRes getTransactions(@RequestHeader("Authorization") String authorization,
                                       @RequestParam("filter") String filter,
                                       @RequestParam(name = "limit",defaultValue = "1000") Integer limit,
                                       @RequestParam(name = "offset",defaultValue = "0") Integer offset);

}
