package com.bailuntec.api.bailuntec.wms.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class WmsLogisticsReconciliationInfo {

    private String targetUrl;
    private Boolean success;
    private String error;
    private String unAuthorizedRequest;
    private Result result;

    @Data
    public class Result {
        private Integer pageIndex;
        private Integer totalPages;
        private Integer total;
        private Boolean hasPreViousPage;
        private Boolean hasNextPage;
        private List<LogisticsInner> result;

        @Data
        public class LogisticsInner {
            @JsonProperty("gmt_id")
            private Integer id;
            @JsonProperty("id")
            private Integer wmsId;
            private String companyCode;
            private String companyName;
            private String lineCode;
            private String lineName;
            private String allocatecargoordercode;
            private String yicangno;
            private String trackingno;
            private LocalDateTime shipmenttime;
            private BigDecimal outputweightkg;
            private BigDecimal bailunshipmentcostcny;
            private BigDecimal merchantoutputweightkg;
            private BigDecimal merchantshipmentcostcny;
            private LocalDateTime merchantreconciliationtime;
            private String reconciliationstatus;
            private String weightdiff;
            private String costdiff;
            private String weightspecificdiff;
            private LocalDateTime thisreconciliatetime;
            private LocalDateTime originalscanningtime;
            private String wareno;
            private String reconciliationuser;
            private String audituser;
            private String auditstatus;
            private String auditremark;
            private String remark;
            private BigDecimal confirmshipmentcostcny;
            private BigDecimal confirmoutputweightkg;
            private String createuser;
            private LocalDateTime creationtime;
            private LocalDateTime lastmodificationtime;

        }
    }


}
