package com.bailuntec.api.bailuntec.purchase;

import com.bailuntec.api.bailuntec.purchase.resp.GetPagePurchaseSkuInfoResp;
import com.bailuntec.api.bailuntec.purchase.resp.GetPurchaseSkuForDataCenterResp;
import com.bailuntec.api.bailuntec.purchase.resp.PurchaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/6 1:30 下午
 */
@FeignClient(name = "purhcase", url = "http://api.purchase.bailuntec.com")
public interface PurchaseApi {

    /**
     * <p>
     * 调用采购单sku流水接口
     * </p>
     *
     * @param start    yyyy-MM-dd HH:mm:ss
     * @param end      yyyy-MM-dd HH:mm:ss
     * @param type     类型
     * @param pagesize page
     * @param page     page
     * @return 采购单sku流水
     */
    @GetMapping("/Api/GetPurchaseSkuForDataCenter")
    PurchaseResult<List<GetPurchaseSkuForDataCenterResp>> getPurchaseSkuForDataCenter(@RequestParam("start") String start,
                                                                                      @RequestParam("end") String end,
                                                                                      @RequestParam("type") Integer type,
                                                                                      @RequestParam("pagesize") Integer pagesize,
                                                                                      @RequestParam("page") Integer page);

    /**
     * <p>调用采购单sku详细信息接口</p>
     *
     * @param start    yyyy-MM-dd HH:mm:ss
     * @param end      yyyy-MM-dd HH:mm:ss
     * @param pagesize page
     * @param page     page
     * @return 采购单sku详细信息
     */
    @GetMapping("/api/GetPagePurchaseSkuInfo")
    PurchaseResult<List<GetPagePurchaseSkuInfoResp>> GetPagePurchaseSkuInfo(@RequestParam("start") String start,
                                                                            @RequestParam("end") String end,
                                                                            @RequestParam("pagesize") Integer pagesize,
                                                                            @RequestParam("page") Integer page);


}

