package com.bailuntec.api.bailuntec.oms.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class GetBailunOrdersResp {

    @JsonProperty("originOrderNo")
    private String originOrderId;

    @JsonProperty("platformType")
    private String platformType;

    @JsonProperty("transactionNo")
    private String transactionId;

    @JsonProperty("payMentInfo")
    private Payment payment;


    @JsonProperty("platOrderType")
    private String platformOrderType;

    @JsonProperty("website")
    private String website;

    @JsonProperty("bailunCreateTime")
    private LocalDateTime createTime;

    @JsonProperty("purchaseTimeUtc")
    private LocalDateTime purchaseCreateTime;

    @JsonProperty("hasPayTimeUtc")
    private Boolean hasPaytime;

    @JsonProperty("payTimeUtc")
    private LocalDateTime paidTime;

    @JsonProperty("refundTimeUtc")
    private LocalDateTime refundTime;

    @JsonProperty("seller")
    private Seller seller;

    @JsonProperty("lastUpdateTimeUtc")
    private LocalDateTime orderUpdateTime;

    @JsonProperty("platSkuItems")
    private List<PlatformSku> platformSku;

    @JsonProperty("pickingOrders")
    private List<PickingOrder> pickingOrder;

    @JsonProperty("wmsFeeDetailsDtos")
    private List<WmsFeeDetailDtos> wmsFeeDetailsDtos;

    @JsonProperty("logisticsItems")
    private List<LogisticsItem> logisticsItems;

    @JsonProperty("orderChecks")
    private List<OrderCheck> orderChecks;

    @JsonProperty("bailunOrderNo")
    private String bailunOrderId;

    @JsonProperty("platOrderStatus")
    private String platformOrderStatus;

    @JsonProperty("bailunOrderStatus")
    private String bailunOrderStatus;

    @JsonProperty("mergeStatus")
    private String bailunMergeStatus;

    @JsonProperty("interceptionStatus")
    private String bailunInterceptionStatus;

    @JsonProperty("bailunPaymentStatus")
    private String bailunPaymentStatus;

    @JsonProperty("shippingStatus")
    private String bailunShippingStatus;

    @JsonProperty("pickingStatus")
    private String bailunPickingStatus;

    @JsonProperty("requirePlatLogistics")
    private String bailunRequireLogistics;

    @JsonProperty("proSkuList")
    private List<BailunSku> bailunSku;

    @JsonProperty("saleItems")
    private List<SaleItem> saleItem;

    @JsonProperty("orderCharge")
    private OrderCharge orderCharge;

    @JsonProperty("orderExceptions")
    private List<OrderException> orderExceptions;

    @JsonProperty("receiptAddress")
    private ReceiptAddress receiptAddress;

    @JsonProperty("buyer")
    private Buyer buyer;

    @JsonProperty("isCancledByPlatform")
    private Boolean hasCancle;

    @JsonProperty("areaId")
    private Integer areaId;

    @JsonProperty("tenantId")
    private Integer companyId;

    @JsonProperty("refund")
    private RefundInfo refundInfo;

    @JsonProperty("afterMergedBailunOrderNo")
    private String aftermergedBailunOrderNo;

    @JsonProperty("isTransferOrder")
    private Boolean hasTransferOrder;

    /**
     * 实际最后发货时间
     */
    @JsonProperty("shippingDeadlineReal")
    private LocalDateTime shippingDeadlineReal;
}
