package com.bailuntec.api.bailuntec.mjzz;

import com.bailuntec.api.bailuntec.mjzz.resp.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/6 3:47 下午
 */
@FeignClient(name = "mjzz",url = "http://mjzz.bailuntec.com")
public interface MjzzApi {

    /**
     * <p>
     * 请求流水接口
     * </p>
     *
     * @param page  page
     * @param rows  page
     * @param btime yyyy-MM-dd HH:mm:ss
     * @param etime yyyy-MM-dd HH:mm:ss
     * @return 流水
     */
    @GetMapping("/api/ApiOrderApply")
    MjzzResult<List<ApiOrderApplyResp>> apiOrderApply(@RequestParam("page") Integer page,
                                                      @RequestParam("rows") Integer rows,
                                                      @RequestParam("btime") String btime,
                                                      @RequestParam("etime") String etime);

    /**
     * <p>
     * 请求流水接口
     * </p>
     *
     * @param page  page
     * @param rows  page
     * @param btime yyyy-MM-dd HH:mm:ss
     * @param etime yyyy-MM-dd HH:mm:ss
     * @return 流水
     */
    @GetMapping("/Material/FullStockLogPage")
    MjzzResult<MjzzPage<FullStockLogPageResp>> fullStockLogPage(@RequestParam("page") Integer page,
                                                                @RequestParam("rows") Integer rows,
                                                                @RequestParam("btime") String btime,
                                                                @RequestParam("etime") String etime);

    /**
     * <p>
     * 请求流水接口
     * </p>
     *
     * @param page page
     * @param rows page
     * @return 流水
     */
    @GetMapping("/api/ProdStockPage")
    MjzzResult<MjzzPage<ProdStockPageResp>> prodStockPage(@RequestParam("page") Integer page,
                                                          @RequestParam("rows") Integer rows);
}
