package com.bailuntec.api.bailuntec.fee;

import com.bailuntec.api.bailuntec.fee.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 1:58 下午
 */
@FeignClient(name = "fee", url = "http://api.fee.bailuntec.com/")
public interface FeeApi {

    /**
     * <p>
     * 请求费用接口
     * </p>
     *
     * @param pageSize  page
     * @param pageIndex page
     * @param startDate 开始时间 yyyy-MM-dd HH:mm:ss
     * @param endDate   结束时间 yyyy-MM-dd HH:mm:ss
     * @return 费用
     */
    @GetMapping("/fee/api/cost/api/getCostList")
    FeeResult<FeePage<CostResp>> getCostList(@RequestParam("pageSize") Integer pageSize,
                                             @RequestParam("pageIndex") Integer pageIndex,
                                             @RequestParam("startDate") String startDate,
                                             @RequestParam("endDate") String endDate);

    /**
     * <p>
     * 请求物流接口
     * </p>
     *
     * @param startDate 开始日期 yyyy-MM-dd
     * @param endDate   结束日期 yyyy-MM-dd
     * @return 物流费用
     */
    @GetMapping("/fee/api/cost/api/logisticsCostList")
    FeeResult<List<LogisticsCostResp>> logisticsCostList(@RequestParam("startDate") String startDate,
                                                         @RequestParam("endDate") String endDate);

    /**
     * <p>
     * 请求管理成本接口同步百伦接口
     * </p>
     *
     * @param startDate 开始时间 yyyy-MM-dd HH:mm:ss
     * @param endDate   结束时间 yyyy-MM-dd HH:mm:ss
     * @return 管理成本
     */
    @GetMapping("/fee/api/cost/api/manageCostList")
    FeeResult<List<ManageCostResp>> manageCostList(@RequestParam("startDate") String startDate,
                                                   @RequestParam("endDate") String endDate,
                                                   @RequestParam(value = "o", defaultValue = "0") String o);
}
