package com.bailuntec.api.bailuntec.cw;

import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.api.bailuntec.cw.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 财务系统
 * </p>
 *
 * @author robbendev
 * @since 2020/9/28 4:02 下午
 */
@FeignClient(name = "cw", url = "http://cw.bailuntec.com/")
public interface CwApi {

    /**
     * 请求流水接口
     *
     * @param rows            记录行数
     * @param BeginModifyTime 最后更新时间begin yyyy-MM-dd HH:mm:ss
     * @param EndModifyTime   最后更新时间end yyyy-MM-dd HH:mm:ss
     * @param Page            页码
     * @return 流水
     */
    @GetMapping("/API/API/getCashiers")
    List<GetCashiersResp> getCashiers(@RequestParam("rows") Integer rows,
                                      @RequestParam("BeginModifyTime") String BeginModifyTime,
                                      @RequestParam("EndModifyTime") String EndModifyTime,
                                      @RequestParam("Page") Integer Page);

    /**
     * 请求流水接口同步百伦接口
     *
     * @param pagesize  分页大小
     * @param begintime 开始时间 yyyy-MM-dd HH:mm:ss
     * @param endtime   结束时间 yyyy-MM-dd HH:mm:ss
     * @param pageindex 页码
     * @return 流水
     */
    @GetMapping("/API/API/GetWithdrawDetailPages")
    GetWithdrawDetailPagesResp getWithdrawDetailPages(@RequestParam("pagesize") Integer pagesize,
                                                      @RequestParam("begintime") String begintime,
                                                      @RequestParam("endtime") String endtime,
                                                      @RequestParam("pageindex") Integer pageindex);

    /**
     * <p>
     * 获取财务手续费
     * </p>
     *
     * @param beginTime 开始时间  yyyy-MM-dd HH:mm:ss
     * @param endTime   结束时间  yyyy-MM-dd HH:mm:ss
     * @return 财务手续费列表
     */
    @GetMapping("/API/API/GetHandleFeeTradeRecords")
    List<GetHandleFeeTradeRecordsResp> getHandleFeeTradeRecords(@RequestParam("beginTime") String beginTime,
                                                                @RequestParam("endTime") String endTime);

    /**
     * <p>请求利息支出接口同步百伦接口</p>
     *
     * @return 利息支出
     */
    @GetMapping("/api/api/GetRepayPlanDetails")
    List<GetRepayPlanDetailsResp> getRepayPlanDetails(@RequestParam("startDate") String startDate,
                                                      @RequestParam("endDate") String endDate);


    /**
     * 推送费用单到财务系统
     *
     * @param req req
     * @return resp
     */
    @PostMapping(value = "/API/API/Apply", consumes = {MediaType.APPLICATION_JSON_VALUE}, produces = MediaType.APPLICATION_JSON_VALUE)
    CwResult<String> postApply(@RequestBody PostApplyReq req);


    /**
     * 获取公司主体借款余额
     *
     * @return 公司主体借款余额
     */
    @GetMapping("/api/api/GetBorrows")
    CwResult<List<BorrowBalanceDTO>> getBorrows();

    /**
     * 获取银行账号余额
     *
     * @return 银行账号余额
     */
    @GetMapping("/api/api/GetBankAccountSummary")
    CwResult<List<BankAccountBalanceDTO>> getBankAccountSummary();

    /**
     * 获取平台提现在途资金信息
     *
     * @return 平台提现在途资金信息
     */
    @GetMapping("/api/api/GetWithdrawOnWaySummary")
    CwResult<List<WithdrawOnWayDTO>> getWithdrawOnWaySummary();

    /**
     * 获取PayPal帐号信息
     *
     * @return PayPal帐号信息
     */
    @GetMapping("/api/api/GetPayPalBalance")
    List<PayPalBalanceDTO> getPayPalBalance();
}
