package com.bailuntec.api;

import com.bailuntec.api.bailuntec.cw.CwApiJackson2HttpMeesageConverter;
import feign.codec.Decoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/12 2:41 下午
 */
@Configuration
@EnableFeignClients(basePackages = {"com.bailuntec.api"})
public class Config {

    @Bean
    public Decoder feignDecoder() {
        CwApiJackson2HttpMeesageConverter cwApiJackson2HttpMeesageConverter = new CwApiJackson2HttpMeesageConverter();
        ObjectFactory<HttpMessageConverters> objectFactory = () -> new HttpMessageConverters(cwApiJackson2HttpMeesageConverter);
        return new SpringDecoder(objectFactory);
    }
}
