package com.bailuntec.api.bailuntec.crm;

import com.bailuntec.api.bailuntec.crm.response.CrmPage;
import com.bailuntec.api.bailuntec.crm.response.CrmResult;
import com.bailuntec.api.bailuntec.crm.response.PayPalLogResp;
import com.bailuntec.api.bailuntec.crm.response.RefundLogResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 1:30 下午
 */
@FeignClient(name = "crm", url = "http://crm.bailuntec.com/")
public interface CrmApi {


    /**
     * <p>
     * CRM退款记录接口
     * </p>
     *
     * @param btime 时间区间上界 yyyy-MM-dd HH:mm:ss
     * @param etime 时间区间下界 yyyy-MM-dd HH:mm:ss
     * @param rows  每页条数
     * @param page  页码
     * @return 退款记录
     */
    @GetMapping("/api/RefundLog")
    CrmResult<CrmPage<RefundLogResp>> refundLog(@RequestParam("btime") String btime,
                                                @RequestParam("etime") String etime,
                                                @RequestParam("rows") Integer rows,
                                                @RequestParam("page") Integer page);

    /**
     * <p>
     * 请求流水接口同步百伦接口
     * </p>
     *
     * @param rows  page
     * @param page  page
     * @param btime 开始时间 yyyy-MM-dd HH:mm:ss
     * @param etime 结束时间 yyyy-MM-dd HH:mm:ss
     * @return
     */
    @GetMapping("/api/PaypalLog")
    CrmResult<CrmPage<PayPalLogResp>> payPalLog(@RequestParam("rows") Integer rows,
                                                @RequestParam("page") Integer page,
                                                @RequestParam("btime") String btime,
                                                @RequestParam("etime") String etime);
}
