package com.bailuntec.ana.vo.order.resp;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单详情sku报表响应
 * </p>
 *
 * @author robbendev
 * @since 2020/8/10 5:14 下午
 */
@Data
@JsonInclude()
public class SellerOrderDetailChartResp {

    @ApiModelProperty("sku编码")
    private String skuNo;

    @ApiModelProperty("平台")
    private String platform;

    @ApiModelProperty("站点")
    private String site;

    @ApiModelProperty("帐号")
    private String account;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("分类")
    private String category;

    @ApiModelProperty("订单数量")
    private Integer orderNum;

    @ApiModelProperty("平均sku售价")
    private BigDecimal averageSkuPrice;

    @ApiModelProperty("sku退货率")
    private BigDecimal refundPercent;

    @ApiModelProperty("采购时间")
    private LocalDateTime purchaseTime;

    @ApiModelProperty("发货时间")
    private LocalDateTime deliveryTime;
}
