package com.bailuntec.ana.vo.order;

import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.DecimalMin;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-31
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "Currency对象", description = "")
public class Currency {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "对人民币汇率")
    private BigDecimal exchangeRate;

    @DecimalMin(value = "0", inclusive = false, message = "金额不能小于0", groups = OrderValidGroup.PublishOrder.class)
    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "货币单位")
    private String currencyCode;

    public static final Currency TEST = new Currency(BigDecimal.ONE, BigDecimal.ONE, "CNY");

    /**
     * <p>
     * 默认货币构造器：CNY
     * </p>
     *
     * @param amount 金额
     */
    public Currency(BigDecimal amount) {
        exchangeRate = BigDecimal.ONE;
        amount = amount;
        currencyCode = "CNY";
    }

    public Currency() {

    }

    public Currency(BigDecimal exchangeRate, BigDecimal amount, String currencyCode) {
        this.exchangeRate = exchangeRate;
        this.amount = amount;
        this.currencyCode = currencyCode;
    }


    /**
     * <p>
     * 获取货币人民币金额
     * </p>
     *
     * @return 人民币金额
     */
    public BigDecimal CNY() {
        return amount.multiply(exchangeRate);
    }

}
