package com.bailuntec.ana.domain.purchase;

import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.vo.order.Currency;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PurchaseOrder对象", description = "")
public class PurchaseOrder extends BaseModel {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单号")
    private String orderNo;

    @ApiModelProperty(value = "采购单加权平均税")
    private Currency totalTax;

    @ApiModelProperty(value = "采购单加权平均邮费")
    private Currency totalShipCost;

    @ApiModelProperty(value = "采购单总sku成本")
    private Currency totalSkuCost;

    @ApiModelProperty(value = "采购单总成本")
    private Currency totalPrice;

    @ApiModelProperty(value = "采购单总成本（CNY）")
    private BigDecimal cnyTotalPrice;

    @ApiModelProperty(value = "采购任务id")
    private String purchaseTaskId;

    @ApiModelProperty(value = "采购平台")
    private String purchasePlat;

    @ApiModelProperty(value = "平台订单id")
    private String orderId;

    @TableField(exist = false)
    private List<PurchaseOrderDetail> purchaseOrderDetailList;

    @TableField(exist = false)
    private LogisticsOrder logisticsOrder;
}
