package com.bailuntec.ana.application.purchase.impl;

import com.bailuntec.ana.application.order.IOrderService;
import com.bailuntec.ana.application.purchase.ILogisticsOrderService;
import com.bailuntec.ana.application.purchase.IPurchaseOrderDetailService;
import com.bailuntec.ana.application.purchase.IPurchaseOrderService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.purchase.LogisticsOrder;
import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.bailuntec.ana.infrastructure.mapper.order.OrderDetailMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.LogisticsOrderMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseOrderMapper;
import com.bailuntec.ana.vo.order.resp.PublishOrderCallBackRequest;
import com.bailuntec.ana.vo.purchase.CallBackLogisticsOrder;
import com.bailuntec.ana.vo.purchase.PmsCallBackResult;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-30
 */
@Service
public class LogisticsOrderServiceImpl extends ServiceImpl<LogisticsOrderMapper, LogisticsOrder> implements ILogisticsOrderService {

    @Resource
    PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    OrderDetailMapper orderDetailMapper;
    @Resource
    IPurchaseOrderDetailService purchaseOrderDetailService;
    @Resource
    IPurchaseOrderService purchaseOrderService;
    @Resource
    IOrderService orderService;

    @Override
    public void callBackLogisticsOrder(PmsCallBackResult<Map<String, CallBackLogisticsOrder>> request) {
        request.getData().forEach((purchaseOrderNo, callBackLogisticsOrder) -> {
            PurchaseOrder purchaseOrder = purchaseOrderMapper.selectByTaskTypeAndOrderNo(request.getName(), purchaseOrderNo);
            purchaseOrderDetailService.setPurchaseOrderDetail(purchaseOrder);

            LogisticsOrder logisticsOrder = new LogisticsOrder();
            logisticsOrder.setCarrier(callBackLogisticsOrder.getCarrier());
            logisticsOrder.setPurchaseOrderId(purchaseOrder.getId());
            logisticsOrder.setPurchaseOrderNo(purchaseOrder.getOrderNo());
            logisticsOrder.setTrackingNumber(callBackLogisticsOrder.getTrackingNumber());
            baseMapper.insert(logisticsOrder);

            purchaseOrder.getPurchaseOrderDetailList().forEach(purchaseOrderDetail -> {
                OrderDetail orderDetail = purchaseOrderDetail.getOrderDetail();
                orderDetail.setDeliveryStatus(OrderDetail.DELIVERY_STATUS_SUCCESS);
                orderDetailMapper.updateById(orderDetail);
            });

            Order order = orderService.queryDetail(purchaseOrder.getOrderId());
            boolean isPartialDelivery = order.getOrderDetailList().stream().anyMatch(orderDetail -> !orderDetail.getDeliveryStatus().equals(OrderDetail.DELIVERY_STATUS_SUCCESS));
            order.setDeliveryStatus(isPartialDelivery ? PublishOrderCallBackRequest.DELIVERY_STATUS_PARTIAL_DELIVERY : Order.DELIVERY_STATUS_SUCCESS);
            orderService.updateById(order);

            purchaseOrderService.callbackOms(order);
        });
    }
}
