package com.bailuntec.ana.interfaces.order;

import com.bailuntec.ana.infrastructure.feign.PamsApi;
import com.bailuntec.ana.infrastructure.feign.PdsApi;
import com.bailuntec.ana.vo.order.Currency;
import com.bailuntec.ana.vo.order.resp.Accounts;
import com.bailuntec.ana.vo.order.resp.PamsBaseResult;
import com.bailuntec.ana.vo.product.resp.PdsSkuInfo;
import com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/6 5:03 下午
 */
@RunWith(SpringRunner.class)
@SpringBootTest
public class OrderControllerTest {

    @MockBean
    PdsApi pdsApi;
    @MockBean
    PamsApi pamsApi;

    @Before
    public void setUp() {
        PdsSkuInfo pdsSkuInfo = new PdsSkuInfo();
        pdsSkuInfo.setTolerance(new Currency(BigDecimal.ONE));
        pdsSkuInfo.setCostPrice(new Currency(BigDecimal.ONE));
        pdsSkuInfo.setPurchasePlat("ebay");
        pdsSkuInfo.setPurchaseAsin("purchase-sku-asin-001");
        pdsSkuInfo.setPurchaseSkuNo("purchase-sku-test-001");


        Mockito.when(pdsApi.queryPdsSku("ebay", "sale-sku-test-001"))
                .thenReturn(pdsSkuInfo);

        Accounts accounts = new Accounts();
        accounts.setAccount("test-account");
        accounts.setId(100);
        accounts.setEmailAccount("test@gmail.com");
        accounts.setOmsCode("AM4501646");
        accounts.setOmsAccount("LagunamoonBeautyESBLT");
        accounts.setPlatformId("15");

        PamsBaseResult<List<Accounts>> result = new PamsBaseResult<>();
        result.setData(Lists.newArrayList(accounts));

        Mockito.when(pamsApi.getAccount("100"))
                .thenReturn(result);
    }

    @Test
    public void publishOrder() {

    }

    @Test
    public void refundOrder() {
    }

    @Test
    public void purchase() {
    }

    @Test
    public void queryPage() {
    }

    @Test
    public void queryDetail() {
    }
}
