package com.bailuntec.ana.interfaces.purchase;


import com.bailuntec.ana.application.purchase.IPurchaseOrderService;
import com.bailuntec.ana.infrastructure.common.base.BaseResult;
import com.bailuntec.ana.infrastructure.common.constant.PurchaseTaskConstant;
import com.bailuntec.ana.infrastructure.common.util.JsonUtilByJackson;
import com.bailuntec.ana.vo.purchase.CallBackLogisticsOrder;
import com.bailuntec.ana.vo.purchase.PmsCallBackResult;
import com.bailuntec.ana.vo.purchase.PurchaseCallBackRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.security.InvalidParameterException;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-30
 */
@Api(tags = "采购订单接口")
@RestController
@RequestMapping("/api/purchaseOrder")
public class PurchaseOrderController {

    @Resource
    IPurchaseOrderService purchaseOrderService;
    @Resource
    LogisticsOrderController logisticsOrderController;

    /**
     * <p>
     * 回调订单采购状态
     * </P>
     *
     * @param request callback
     * @return CallBackPurchaseOrder
     */
    @ApiOperation("回调订单采购状态")
    @PostMapping("/callBackPurchaseOrder")
    public BaseResult<Void> callBackPurchaseOrder(@RequestBody PmsCallBackResult<PurchaseCallBackRequest> request) {
        purchaseOrderService.callBackPurchaseOrder(request);
        return BaseResult.success();
    }


    @ApiOperation("采购订单通用回调")
    @PostMapping("/commonPmsCallback")
    public BaseResult<Void> commonPmsCallback(@RequestBody String callbackJson) {
        Map<String, Object> map = JsonUtilByJackson.readValue(callbackJson, new TypeReference<Map<String, Object>>() {
        });
        if (map == null) {
            throw new InvalidParameterException();
        }
        String name = String.valueOf(map.get("name"));

        switch (name) {
            case PurchaseTaskConstant.ebayPurchase:
                PmsCallBackResult<PurchaseCallBackRequest> request = JsonUtilByJackson.readValue(callbackJson, new TypeReference<PmsCallBackResult<PurchaseCallBackRequest>>() {
                });
                return this.callBackPurchaseOrder(request);
            case PurchaseTaskConstant.ebayTracking:
                PmsCallBackResult<Map<String, CallBackLogisticsOrder>> callBackLogisticsOrder = JsonUtilByJackson.readValue(callbackJson, new TypeReference<PmsCallBackResult<Map<String, CallBackLogisticsOrder>>>() {
                });
                return logisticsOrderController.callBackLogisticsOrder(callBackLogisticsOrder);
            default:
                throw new InvalidParameterException();
        }
    }
}
