package com.bailuntec.ana.infrastructure.mapper.purchase;

import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
public interface PurchaseOrderMapper extends BaseMapper<PurchaseOrder> {

    /**
     * <p>
     * 根据平台订单id查询采购订单
     * </p>
     *
     * @param orderId 平台订单id
     * @return 采购订单
     */
    List<PurchaseOrder> selectByOrderId(String orderId);

    /**
     * <p>
     * 根据采购任务的任务类型和采购订单号查询采购订单
     * </p>
     *
     * @param taskType        采购任务类型
     * @param purchaseOrderNo 采购订单号
     * @return 采购订单
     */
    PurchaseOrder selectByTaskTypeAndOrderNo(@Param("taskType") String taskType, @Param("purchaseOrderNo") String purchaseOrderNo);
}
