package com.bailuntec.ana.infrastructure.common.util.lock;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

/**
 * <p>
 * 分段锁，系统提供一定数量的原始锁，根据传入id值获取对应的锁并加锁  
 * 注意：要锁的用户id值如果发生改变，有可能导致锁无法成功释放!!!
 * </p>
 *
 * @author robbendev
 * @since 2020/7/29 4:28 下午
 */
public class OrderIdLock {

    private final static HashMap<Long, ReentrantLock> lockMap = new HashMap<>();

    // 默认分段数量
    private Integer segments = 30;

    private OrderIdLock() {
        init(null, false);
    }

    private OrderIdLock(Integer counts, boolean fair) {
        init(counts, fair);
    }

    /*静态内部类实现单例*/
    public static OrderIdLock getInstance() {
        return SingletonHolder.instance;
    }

    private void init(Integer counts, boolean fair) {
        if (counts != null) {
            segments = counts;
        }
        for (long i = 0; i < segments; i++) {
            lockMap.put(i, new ReentrantLock(fair));
        }
    }

    public void lock(long key) {
        ReentrantLock lock = lockMap.get(key % segments);
        lock.lock();
    }

    public void unlock(long key) {
        ReentrantLock lock = lockMap.get(key % segments);
        lock.unlock();
    }

    @Override
    public String toString() {
        return "SegmentLock [segments=" + segments + ", lockMap=" + lockMap
                + "]";
    }

    /*静态内部类实现单例*/
    private static class SingletonHolder {
        private static final OrderIdLock instance = new OrderIdLock(null, true);
    }

}
