package com.bailuntec.ana.application.address.impl;

import com.bailuntec.ana.application.address.IOrderAddressService;
import com.bailuntec.ana.domain.address.OrderAddress;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.infrastructure.common.util.ListUtil;
import com.bailuntec.ana.infrastructure.mapper.address.OrderAddressMapper;
import com.bailuntec.ana.vo.purchase.ShippingInfo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Service
public class OrderAddressServiceImpl extends ServiceImpl<OrderAddressMapper, OrderAddress> implements IOrderAddressService {

    @Override
    public ShippingInfo buildPurchaseShippingInfo(OrderAddress orderAddress) {


        ShippingInfo shippingInfo = new ShippingInfo();
        shippingInfo.setAddress1(orderAddress.getAddress());
        shippingInfo.setAddress2(orderAddress.getAddress2());
        shippingInfo.setCountry(orderAddress.getCountryCode());
        shippingInfo.setCity(orderAddress.getCity());
        shippingInfo.setState(orderAddress.getStateOrRegion());
        shippingInfo.setZipcode(orderAddress.getPostalCode());
        shippingInfo.setName(orderAddress.getReceiver());
        shippingInfo.setPhone(orderAddress.getPhone());

        return shippingInfo;
    }

    @Override
    public void setOrderAddress(Order order) {
        OrderAddress orderAddress = baseMapper.selectByOrderId(order.getId());
        order.setOrderAddress(orderAddress);
    }

    @Override
    public void setOrderAddress(List<Order> orderList) {
        List<String> orderIdList = orderList.stream().map(Order::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(orderIdList)) {
            List<OrderAddress> orderAddressList = baseMapper.selectList(new LambdaQueryWrapper<OrderAddress>()
                    .in(OrderAddress::getOrderId, orderIdList));
            Map<String, OrderAddress> orderAddressMap = orderAddressList.stream()
                    .collect(Collectors.toMap(OrderAddress::getOrderId, orderAddress -> orderAddress, (k1, k2) -> k1));

            orderList.forEach(order -> {
                order.setOrderAddress(orderAddressMap.get(order.getId()));
            });

        }
    }


}
