package com.bailuntec.ana.vo.purchase;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * ebay 采购下单参数
 * </p>
 *
 * @author robbendev
 * @since 2020/7/30 3:21 下午
 */
@Data
public class PurchaseRequest {

    @ApiModelProperty(value = "采购订单结果查询id")
    private String purchaseOrderCallbackId;

    @ApiModelProperty(value = "站点,支持us uk de等(小写)")
    private String site;

    @ApiModelProperty("成本")
    private BigDecimal cost_price;

    @ApiModelProperty("容忍超过成本范围 超出不进行采购")
    private BigDecimal tolerance;

    @ApiModelProperty("采购")
    private List<PurchaseProduct> products;

    private ShippingInfo shipping_info;
}
