package com.bailuntec.ana.vo.product.resp;

import com.bailuntec.ana.vo.order.Currency;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * mock刊登系统sku返回值
 * </p>
 *
 * @author robbendev
 * @since 2020/8/4 4:19 下午
 */
@Data
public class PdsSkuInfo {

    @ApiModelProperty(value = "销售平台")
    private String platform;

    @ApiModelProperty(value = "订单 平台sku编码")
    private String skuNo;

    @ApiModelProperty(value = "采购平台")
    private String purchasePlat;

    @ApiModelProperty(value = "待采购 平台spuId 从刊登系统获取")
    private String purchaseAsin;

    @ApiModelProperty(value = "待采购 平台sku编号 从刊登系统获取")
    private String purchaseSkuNo;

    @ApiModelProperty(value = "采购成本")
    private Currency costPrice;

    @ApiModelProperty(value = "容忍超过成本范围 超出不进行采购")
    private Currency tolerance;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "分类")
    private String category;


}
