package com.bailuntec.ana.interfaces.order;


import com.bailuntec.ana.application.order.IOrderDetailService;
import com.bailuntec.ana.infrastructure.common.base.BaseResult;
import com.bailuntec.ana.vo.order.req.SellerOrderDetailChartRequest;
import com.bailuntec.ana.vo.order.resp.SellerOrderDetailChartResp;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 订单详情接口
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Api(tags = "订单详情接口")
@RestController
@RequestMapping("/api/orderDetail")
public class OrderDetailController {

    @Resource
    IOrderDetailService orderDetailService;

    @PostMapping("/sellerOrderDetailChartResp")
    public BaseResult<Page<SellerOrderDetailChartResp>> sellerOrderDetailChartResp(@RequestBody SellerOrderDetailChartRequest request) {
        Page<SellerOrderDetailChartResp> page = orderDetailService.sellerOrderDetailChartResp(request);
        return BaseResult.success(page);
    }

}
