package com.bailuntec.ana.infrastructure.mapper.order;

import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.vo.order.req.SellerOrderDetailChartRequest;
import com.bailuntec.ana.vo.order.resp.SellerOrderDetailChartResp;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface OrderDetailMapper extends BaseMapper<OrderDetail> {

    /**
     * <p>
     * 根据订单id查询订单平台sku
     * </p>
     *
     * @param id orderId
     * @return orderDetailList
     */
    List<OrderDetail> selectByOrderId(String id);

    /**
     * <p>
     * 根据订单id查询订单平台sku
     * </p>
     *
     * @param id             orderId
     * @param purchaseStatus purchaseStatus
     * @return orderDetailList
     */
    List<OrderDetail> selectByOrderIdAndPurchaseStatus(@Param("id") String id, @Param("purchaseStatus") Integer purchaseStatus);

    /**
     * <p>
     * 查询采购任务对应的订单详情列表
     * </p>
     *
     * @param purchaseTaskId 采购任务id
     * @return 订单详情列表
     */
    List<OrderDetail> selectByTaskId(String purchaseTaskId);

    /**
     * <p>
     * 销售sku报表
     * </p>
     *
     * @param page    page
     * @param request request
     * @return 报表
     */
    Page<SellerOrderDetailChartResp> sellerOrderDetailChartResp(Page<SellerOrderDetailChartResp> page, SellerOrderDetailChartRequest request);
}
