package com.bailuntec.ana.domain.purchase;

import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.vo.order.Currency;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PurchaseOrderDetail对象", description = "")
public class PurchaseOrderDetail extends BaseModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "采购订单id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单平台skuId")
    private String purchaseOrderId;

    @ApiModelProperty(value = "平台订单详情id")
    private String orderDetailId;

    @ApiModelProperty(value = "采购skuNo")
    private String sku;

    @ApiModelProperty(value = "采购listing页面爬虫需要的id 亚马逊是skuId、ebay是spuId")
    private String asin;

    @ApiModelProperty(value = "sku成本")
    private Currency price;

    @ApiModelProperty(value = "sku采购总额")
    private Currency skuCost;

    @ApiModelProperty(value = "加权平均邮费")
    private Currency shipCost;

    @ApiModelProperty(value = "加权平均税")
    private Currency tax;

    @ApiModelProperty(value = "卖家ID 采购系统回调回传")
    private String merchantId;

    @TableField(exist = false)
    private OrderDetail orderDetail;


}
