package com.bailuntec.ana.application.address;

import com.bailuntec.ana.domain.address.OrderAddress;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.vo.purchase.ShippingInfo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface IOrderAddressService extends IService<OrderAddress> {

    /**
     * <p>
     * 构建订单对应下发采购任务的地址对象
     * </p>
     *
     * @param orderAddress 订单地址
     * @return 下发采购任务参数里面的地址对象
     */
    ShippingInfo buildPurchaseShippingInfo(OrderAddress orderAddress);


    /**
     * <p>
     * 设置订单地址
     * </p>
     *
     * @param order 订单
     */
    void setOrderAddress(Order order);

    /**
     * <p>
     * 设置订单地址
     * </p>
     *
     * @param orderList 订单列表
     */
    void setOrderAddress(List<Order> orderList);
}
