package com.bailuntec.ana.vo.order.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * oms推送订单回调参数
 * </p>
 *
 * @author robbendev
 * @since 2020/7/31 11:11 上午
 */
@Data
public class PublishOrderCallBackRequest {

    //部分采购
    public static final Integer PURCHASE_STATUS_PARTIAL_PURCHASE = 0;
    //全部已采购
    public static final Integer PURCHASE_STATUS_SUCCESS = 1;
    //部分发货
    public static final Integer DELIVERY_STATUS_PARTIAL_DELIVERY = 2;
    //全部已发货
    public static final Integer DELIVERY_STATUS_SUCCESS = 3;

    @JsonProperty("OriginalOrderNo")
    @ApiModelProperty("平台单号")
    private String originalOrderNo;

    @JsonProperty("PdsAccountId")
    @ApiModelProperty("平台帐号id")
    private String pdsAccountId;

    @JsonProperty("Status")
    @ApiModelProperty("状态 状态 0：部分下单，1：完全下单，2：部分发货，3：完全发货，这个有改动了，注意一下")
    private Integer status;

    @JsonProperty("PurchaseInfos")
    @ApiModelProperty("采购信息")
    private List<PurchaseInfo> purchaseInfos;
}
