package com.bailuntec.ana.infrastructure.feign;

import com.bailuntec.ana.vo.order.resp.Accounts;
import com.bailuntec.ana.vo.order.resp.PamsBaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * pams第三方接口
 * </p>
 *
 * @author robbendev
 * @since 2020/7/31 1:48 下午
 */
@FeignClient(name = "PamsApi", url = "http://pams.bailuntec.com/")
public interface PamsApi {

    /**
     * <p>
     * 通过销售帐号id获取帐号信息
     * </p>
     *
     * @param id 销售帐号id
     * @return 销售帐号信息
     */
    @GetMapping("/Api/GetAccounts")
    PamsBaseResult<List<Accounts>> getAccount(@RequestParam String id);

}
