package com.bailuntec.ana.domain.common;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * <p>
 * 字典表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-05
 */
@Data
@ApiModel(value = "Dict对象", description = "字典表")
public class Dict {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "字典描述")
    private String dictDesc;

    @ApiModelProperty(value = "字典编码")
    private String dictCode;

    @ApiModelProperty(value = "字典key")
    private String dictKey;

    @ApiModelProperty(value = "字典值")
    private String dictValue;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "记录创建时间", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    protected LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "记录最后修改时间", hidden = true)
    @TableField(fill = FieldFill.INSERT_UPDATE)
    protected LocalDateTime lastUpdateTime;


}
