package com.bailuntec.ana.application.purchase;

import com.bailuntec.ana.domain.purchase.LogisticsOrder;
import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.bailuntec.ana.vo.purchase.CallBackLogisticsOrder;
import com.bailuntec.ana.vo.purchase.PmsCallBackResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-30
 */
public interface ILogisticsOrderService extends IService<LogisticsOrder> {

    /**
     * <p>
     * 物流信息回调
     * </p>
     *
     * @param request
     */
    void callBackLogisticsOrder(PmsCallBackResult<Map<String, CallBackLogisticsOrder>> request);

    /**
     * 设置采购单物流信息
     *
     * @param purchaseOrderList 采购单列表
     */
    void setLogisticsOrder(List<PurchaseOrder> purchaseOrderList);
}
