package com.bailuntec.ana.vo.order;

import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.DecimalMin;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-31
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel(value = "Currency对象", description = "")
public class Currency {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "汇率")
    private BigDecimal exchangeRate;

    @DecimalMin(value = "0", inclusive = false, message = "金额不能小于0", groups = OrderValidGroup.PublishOrder.class)
    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "货币单位")
    private String currencyCode;


}
