package com.bailuntec.ana.infrastructure.mapper.order;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.vo.order.req.OrderQueryPageRequest;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface OrderMapper extends BaseMapper<Order> {

    /**
     * 根据系统订单号查询订单
     *
     * @param originalOrderNo 平台订单号
     * @param pdsAccountId    平台账号id
     * @return order
     */
    Order selectByOrderNoAndPdsAccountId(@Param("originalOrderNo") String originalOrderNo, @Param("pdsAccountId") String pdsAccountId);


    /**
     * <p>
     * 分页查询订单
     * </p>
     *
     * @param page    分页参数
     * @param param 搜索条件
     * @return
     */
    Page<Order> queryPage(@Param("page") Page<Order>page, @Param("param") OrderQueryPageRequest param);

}
