package com.bailuntec.ana.domain.address;

import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 订单收货人信息
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "OrderAddress对象", description = "订单收货人信息")
public class OrderAddress extends BaseModel {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "ana-order id")
    private String orderId;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "国家不能为空")
    @ApiModelProperty(value = "国家")
    private String countryCode;

    @ApiModelProperty(value = "地区")
    private String area;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "国家不能为空")
    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "州")
    private String stateOrRegion;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "地址不能为空")
    @ApiModelProperty(value = "地址1")
    private String address;

    @ApiModelProperty(value = "地址2")
    private String address2;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "收货人姓名不能为空")
    @ApiModelProperty(value = "收货人姓名")
    private String receiver;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "电话不能为空")
    @ApiModelProperty(value = "电话")
    private String phone;

    private String phone2;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "邮编不能为空")
    @ApiModelProperty(value = "邮编")
    private String postalCode;


}
