package com.bailuntec.ana.application.order;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.vo.order.req.OrderQueryPageRequest;
import com.bailuntec.ana.vo.order.req.RefundOrderRequest;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface IOrderService extends IService<Order> {

    /**
     * <p>
     * oms推送订单
     * 根据oms推送订单保存订单聚合
     * 无并发控制，数据库根据订单号唯一索引控制
     * </p>
     *
     * @param order param
     */
    void publishOrder(Order order);

    /**
     * <p>
     * oms退款完成推送到ana-order
     * 更新订单销售退款字段 ，可以重复更新。
     * 记录更新日志
     * </p>
     *
     * @param request req
     */
    void orderSalesRefund(RefundOrderRequest request);


    /**
     * <p>
     * 发起采购
     * </p>
     *
     * @param id {@link OrderDetail#getId()}
     */
    void purchase(String id);


    /**
     * <p>
     * 查询订单详情
     * </p>
     *
     * @param id id
     * @return order
     */
    Order queryDetail(String id);

    /**
     * <p>
     * 分页查询订单列表
     * </p>
     *
     * @param request
     * @return
     */
    Page<Order> queryPage(OrderQueryPageRequest request);


    /**
     * <p>
     * 从pams同步订单里面的刊登帐号信息
     * </p>
     *
     * @param orderId 订单id
     */
    void syncOrderPdsAccount(String orderId);


    /**
     * <p>
     * 从刊登系统同步订单详情销售sku对应的采购item，采购sku，成本
     * </p>
     *
     * @param orderId 订单id
     */
    void syncOrderDetails(String orderId);


}
