package com.bailuntec.ana.infrastructure.common.feign;

import com.bailuntec.ana.infrastructure.common.util.JsonUtilByFsJson;
import com.bailuntec.ana.vo.order.Currency;
import com.bailuntec.ana.vo.order.resp.OmsBaseResult;
import com.bailuntec.ana.vo.order.resp.PublishOrderCallBackRequest;
import com.google.common.collect.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/1 10:21 上午
 */
@RunWith(SpringRunner.class)
@SpringBootTest
public class OmsApiTest {

    @Resource
    OmsApi omsApi;

    @Test
    public void updateOrderStatusForAna() {
        PublishOrderCallBackRequest request = new PublishOrderCallBackRequest();
        request.setOriginalOrderNo("OR000001");
        request.setPdsAccountId("pds0001");
        request.setStatus(1);
        request.setTax(new Currency(BigDecimal.ONE, new BigDecimal("1.0001"), "CNY"));
        request.setTotalPrice(new Currency(BigDecimal.ONE, new BigDecimal("100.0001"), "CNY"));
        request.setTrackingNos(Lists.newArrayList("TRA00001", "TRA00002"));
        OmsBaseResult<Void> result = omsApi.updateOrderStatusForAna(request);
        System.out.println(JsonUtilByFsJson.beanToJson(result));
    }
}
