package com.bailuntec.ana.interfaces.order;


import com.bailuntec.ana.application.order.IOrderService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.infrastructure.common.base.BaseResult;
import com.bailuntec.ana.infrastructure.common.util.lock.OrderIdLock;
import com.bailuntec.ana.vo.order.req.RefundOrderRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Api(tags = "订单接口")
@RestController
@RequestMapping("/api/order")
public class OrderController {
    @Resource
    IOrderService orderService;

    @ApiOperation("/oms推送订单")
    @PostMapping("/publishOrder")
    public BaseResult<Void> publishOrder(@RequestBody Order order) {
        orderService.publishOrder(order);
        return BaseResult.success();
    }

    @ApiOperation("/oms退款完成推送到ana-order")
    @PostMapping("/orderSalesRefund")
    public BaseResult<Void> refundOrder(@RequestBody RefundOrderRequest request) {
        orderService.orderSalesRefund(request);
        return BaseResult.success();
    }

    @ApiOperation("/发起采购")
    @GetMapping("/purchase")
    public BaseResult<Void> purchase(@RequestParam String id) {
        OrderIdLock lock = OrderIdLock.getInstance();
        long idLong = Long.parseLong(id);
        try {
            lock.lock(idLong);
            orderService.purchase(id);
            return BaseResult.success();
        } finally {
            lock.unlock(idLong);
        }
    }
}
