package com.bailuntec.ana.infrastructure.common.util.seq;


/**
 * 分布式有序ID获取实现
 *
 * @author robbendev
 */
public class IdWorker {

    /**
     * 主机和进程的机器码
     */
    private static Sequence SEQUENCE = new Sequence();

    public static String getId() {
        return String.valueOf(SEQUENCE.nextId());
    }

    /**
     * <p>
     * 有参构造器
     * </p>
     *
     * @param workerId     工作机器 ID
     * @param datacenterId 序列号
     */
    public static void initSequence(long workerId, long datacenterId) {
        SEQUENCE = new Sequence(workerId, datacenterId);
    }
}
