package com.bailuntec.ana.infrastructure.common.feign;

import com.bailuntec.ana.vo.purchase.PurchaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 自动采购系统接口
 * </p>
 *
 * @author robbendev
 * @since 2020/7/31 3:11 下午
 */
@FeignClient(name = "PmsApi", url = "http://pms.bailuntec.com/", fallback = PmsApi.PmsApiFallback.class)
public interface PmsApi {


    /**
     * <p>
     * 下发采购任务
     * </p>
     *
     * @param callBackID 回调ID
     * @param user       用户id=1
     * @param request    req
     * @return result
     */
    @PostMapping("/service/task")
    String task(@RequestParam String task,
                @RequestParam String callBackID,
                @RequestParam Integer user,
                @RequestBody PurchaseRequest request);

    @Slf4j
    @Component
    class PmsApiFallback implements PmsApi {

        @Override
        public String task(String task, String callBackID, Integer user, PurchaseRequest request) {
            log.error("下发采购任务失败");
            return "success";
        }
    }

}
