package com.bailuntec.ana.infrastructure.common.exception;

import com.bailuntec.ana.infrastructure.common.base.BaseResult;
import com.bailuntec.ana.infrastructure.service.mail.MailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * <p>
 * 全局异常处理
 * </p>
 *
 * @author robbendev
 * @since 2020/7/7 9:52 上午
 */
@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @Value("${spring.profiles.active}")
    private String profile;

    @Resource
    MailService mailService;


    /**
     * 自定义异常
     */
    @ExceptionHandler(BizRuntimeException.class)
    public BaseResult<String> handleRRException(HttpServletRequest request,
                                                BizRuntimeException e) {
        BaseResult<String> result = new BaseResult<>();
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());

        log.error(e.getMessage());
        return result;
    }
    /**
     * 未捕获异常
     */
    @ExceptionHandler(Exception.class)
    public BaseResult<String> handleException(HttpServletRequest request,
                                              Exception e) {
        BaseResult<String> result = new BaseResult<>();
        result.setCode("500");
        result.setMessage(e.getMessage());

        //输出日志
        this.log(e, request);

        //错误邮件内容
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);

        //发送邮件
        if (profile.equals("prod"))
            mailService.sendSimpleMail("robbendev@qq.com", profile + "异常", sw.toString());

        return result;
    }


    private void log(Exception ex, HttpServletRequest request) {
        log.error("************************异常开始*******************************");
        log.error("uri,{}", request.getRequestURI());
        log.error("params:{}", request.getParameterMap().toString());
        log.error(ex.getMessage(), ex);
        log.error("************************异常结束*******************************");
    }
}
