package com.bailuntec.ana.domain.order;

import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "OrderPlatformSku对象", description = "")
public class OrderDetail extends BaseModel {

    private static final long serialVersionUID = 1L;

    //未采购
    public static final Integer PURCHASE_STATUS_UN_PURCHASE = 1;
    //部分采购
    public static final Integer PURCHASE_STATUS_PURCHASING = 2;
    //采购失败
    public static final Integer PURCHASE_STATUS_FAILED = 3;
    //全部已采购
    public static final Integer PURCHASE_STATUS_SUCCESS = 4;

    //未发货
    public static final Integer DELIVERY_STATUS_UN_DELIVERY = 1;
    //已发货
    public static final Integer DELIVERY_STATUS_SUCCESS = 2;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @ApiModelProperty(value = "订单 平台sku编码")
    private String skuNo;

    @ApiModelProperty(value = "订单 平台spuId")
    private String itemId;

    @ApiModelProperty(value = "待采购 平台spuId 从刊登系统获取")
    private String purchaseAsin;

    @ApiModelProperty(value = "待采购 平台sku编号 从刊登系统获取")
    private String purchaseSkuNo;

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "源链接")
    private String originalLink;

    @ApiModelProperty(value = "采购状态1-未采购 2-采购中 3-采购失败 4-采购完成")
    private Integer purchaseStatus;

    private String purchaseMessage;

    @ApiModelProperty("发货状态 1-未发货 2-已发货")
    private Integer deliveryStatus;

    @TableField(exist = false)
    private List<OrderSpecification> orderSpecificationList;

}
