package com.bailuntec.ana.domain.order;

import com.bailuntec.ana.domain.address.OrderAddress;
import com.bailuntec.ana.infrastructure.common.annotation.DictParam;
import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.vo.order.Currency;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * ana-order订单
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "Order对象", description = "ana-order订单")
@TableName(value = "`order`")
public class Order extends BaseModel {

    private static final long serialVersionUID = 1L;


    //未采购
    public static final Integer PURCHASE_STATUS_UN_PURCHASE = 1;
    //部分采购
    public static final Integer PURCHASE_STATUS_PARTIAL_PURCHASE = 2;
    //全部已采购
    public static final Integer PURCHASE_STATUS_SUCCESS = 3;
    //未发货
    public static final Integer DELIVERY_STATUS_UN_DELIVERY = 1;
    //部分发货
    public static final Integer DELIVERY_STATUS_PARTIAL_DELIVERY = 2;
    //全部已发货
    public static final Integer DELIVERY_STATUS_SUCCESS = 3;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "平台订单号")
    private String originalOrderNo;

    @ApiModelProperty(value = "系统订单号")
    private String bailunOrderNo;

    @ApiModelProperty(value = "平台")
    private String platform;

    @ApiModelProperty(value = "站点")
    private String site;

    @ApiModelProperty(value = "刊登帐号")
    private String pdsAccount;

    @ApiModelProperty(value = "刊登帐号id")
    private String pdsAccountId;

    @ApiModelProperty(value = "采购平台")
    private String purchasePlat;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "销售金额")
    private Currency salePrice;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "采购价")
    private Currency purchasePrice;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "ebay_fee")
    private Currency ebayFee;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "销售退款金额")
    private Currency salesRefundAmount;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "采购退款金额")
    private Currency purchaseRefundAmount;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "利润")
    private Currency profit;

    @DictParam(dictCode = "ORDER_STATUS", dictValueParam = "statusStr")
    @ApiModelProperty(value = "1-正常 2-已取消")
    private Integer status;

    @TableField(exist = false)
    @ApiModelProperty(value = "1-正常 2-已取消")
    private String statusStr;

    @DictParam(dictCode = "ORDER_PURCHASE_STATUS", dictValueParam = "purchaseStatusStr")
    @ApiModelProperty(value = "采购状态1-未采购 2-采购中 3-采购失败 3-采购完成")
    private Integer purchaseStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "采购状态1-未采购 2-部分已采购 3-全部已采购")
    private String purchaseStatusStr;

    @DictParam(dictCode = "ORDER_DELIVERY_STATUS", dictValueParam = "deliveryStatusStr")
    @ApiModelProperty(value = "发货状态 1-未发货 2-部分已发货 3-全部已采购")
    private Integer deliveryStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "发货状态 1-未发货 2-部分已发货 3-全部已采购")
    private String deliveryStatusStr;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "oms订单创建时间")
    private LocalDateTime omsOrderCreateTime;

    @ApiModelProperty(value = "采购订单结果查询id")
    private String purchaseOrderCallbackId;

    @ApiModelProperty(value = "订单待采购sku详情")
    @TableField(exist = false)
    private List<OrderDetail> orderDetailList;

    @TableField(exist = false)
    private OrderAddress orderAddress;

}
