package com.bailuntec.ana.application.purchase.impl;

import com.bailuntec.ana.application.address.IOrderAddressService;
import com.bailuntec.ana.application.purchase.IPurchaseTaskService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.order.OrderSpecification;
import com.bailuntec.ana.domain.purchase.PurchaseTask;
import com.bailuntec.ana.domain.purchase.PurchaseTaskDetail;
import com.bailuntec.ana.infrastructure.common.feign.PmsApi;
import com.bailuntec.ana.infrastructure.mapper.order.OrderDetailMapper;
import com.bailuntec.ana.infrastructure.mapper.order.OrderMapper;
import com.bailuntec.ana.infrastructure.mapper.order.OrderSpecificationMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseTaskDetailMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseTaskMapper;
import com.bailuntec.ana.vo.purchase.PurchaseProduct;
import com.bailuntec.ana.vo.purchase.PurchaseRequest;
import com.bailuntec.ana.vo.purchase.ShippingInfo;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Service
public class PurchaseTaskServiceImpl extends ServiceImpl<PurchaseTaskMapper, PurchaseTask> implements IPurchaseTaskService {

    @Resource
    PurchaseTaskMapper purchaseTaskMapper;
    @Resource
    PurchaseTaskDetailMapper purchaseTaskDetailMapper;
    @Resource
    PmsApi pmsApi;
    @Resource
    OrderMapper orderMapper;
    @Resource
    OrderDetailMapper orderDetailMapper;
    @Resource
    IOrderAddressService orderAddressService;
    @Resource
    OrderSpecificationMapper orderSpecificationMapper;

    @Override
    public void addTask(List<String> orderDetailIdList, String orderId, String taskType) {
        PurchaseTask purchaseTask = new PurchaseTask();
        purchaseTask.setOrderId(orderId);
        purchaseTask.setTaskType(taskType);
        purchaseTaskMapper.insert(purchaseTask);

        orderDetailIdList.forEach(orderDetailId -> {
            PurchaseTaskDetail purchaseTaskDetail = new PurchaseTaskDetail();
            purchaseTaskDetail.setOrderDetailId(orderDetailId);
            purchaseTaskDetail.setPurchaseTaskId(purchaseTask.getId());
            purchaseTaskDetailMapper.insert(purchaseTaskDetail);
        });


        Order order = orderMapper.selectById(orderId);
        PurchaseRequest purchaseRequest = new PurchaseRequest();
        purchaseRequest.setSite(order.getSite());

        ShippingInfo shippingInfo = orderAddressService.buildPurchaseShippingInfo(orderId);

        purchaseRequest.setShipping_info(shippingInfo);
        purchaseRequest.setPurchaseOrderCallbackId(purchaseTask.getId());
        purchaseRequest.setProducts(orderDetailIdList.stream()
                .map(orderDetailId -> {
                    OrderDetail orderDetail = orderDetailMapper.selectById(orderDetailId);
                    List<OrderSpecification> orderSpecificationList = orderSpecificationMapper.selectByOrderDetailId(orderDetail.getId());
                    PurchaseProduct purchaseProduct = new PurchaseProduct();
                    purchaseProduct.setAttr(orderSpecificationList.stream().collect(Collectors.toMap(
                            OrderSpecification::getName, OrderSpecification::getValue, (k1, k2) -> k1
                    )));
                    purchaseProduct.setSku(orderDetail.getPurchaseSkuNo());
                    purchaseProduct.setQuantity(orderDetail.getQuantity());
                    purchaseProduct.setAsin(orderDetail.getPurchaseAsin());

                    orderDetail.setPurchaseStatus(OrderDetail.PURCHASE_STATUS_PURCHASING);
                    orderDetailMapper.updateById(orderDetail);

                    return purchaseProduct;
                })
                .collect(Collectors.toList()));

        pmsApi.task(taskType, purchaseTask.getId(), 1, purchaseRequest);

    }
}
