package com.bailuntec.ana.application.order;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.vo.order.req.RefundOrderRequest;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface IOrderService extends IService<Order> {

    /**
     * <p>
     * oms推送订单
     * 根据oms推送订单保存订单聚合
     * 无并发控制，数据库根据订单号唯一索引控制
     * </p>
     *
     * @param order param
     */
    void publishOrder(Order order);

    /**
     * <p>
     * oms退款完成推送到ana-order
     * 更新订单销售退款字段 ，可以重复更新。
     * 记录更新日志
     * </p>
     *
     * @param request req
     */
    void orderSalesRefund(RefundOrderRequest request);


    /**
     * <p>
     * 发起采购
     * </p>
     *
     * @param id {@link OrderDetail#getId()}
     */
    void purchase(String id);


    /**
     * <p>
     * 同步订单平台sku采购结果
     * </p>
     */
    void syncPurchaseStatus();

    /**
     * <p>
     * 查询订单详情
     * </p>
     *
     * @param id id
     * @return order
     */
    Order queryDetail(String id);
}
