package com.bailuntec.ana.application.address.impl;

import com.bailuntec.ana.application.address.IOrderAddressService;
import com.bailuntec.ana.domain.address.OrderAddress;
import com.bailuntec.ana.infrastructure.mapper.address.OrderAddressMapper;
import com.bailuntec.ana.vo.purchase.ShippingInfo;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Service
public class OrderAddressServiceImpl extends ServiceImpl<OrderAddressMapper, OrderAddress> implements IOrderAddressService {

    @Override
    public ShippingInfo buildPurchaseShippingInfo(String orderId) {

        OrderAddress orderAddress = baseMapper.selectByOrderId(orderId);

        ShippingInfo shippingInfo = new ShippingInfo();
        shippingInfo.setAddress1(orderAddress.getAddress());
        shippingInfo.setAddress2(orderAddress.getAddress2());
        shippingInfo.setCountry(orderAddress.getCountryCode());
        shippingInfo.setCity(orderAddress.getCity());
        shippingInfo.setState(orderAddress.getStateOrRegion());
        shippingInfo.setZipcode(orderAddress.getPostalCode());
        shippingInfo.setName(orderAddress.getReceiver());
        shippingInfo.setPhone(orderAddress.getPhone());

        return shippingInfo;
    }
}
