package com.bailuntec.ana.interfaces.order;


import com.bailuntec.ana.application.order.IOrderService;
import com.bailuntec.ana.application.purchase.IPurchaseTaskService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.infrastructure.common.base.BaseResult;
import com.bailuntec.ana.infrastructure.common.exception.BizRuntimeException;
import com.bailuntec.ana.infrastructure.common.exception.ErrorCode;
import com.bailuntec.ana.infrastructure.common.util.lock.OrderIdLock;
import com.bailuntec.ana.vo.order.req.OrderQueryPageRequest;
import com.bailuntec.ana.vo.order.req.RefundOrderRequest;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Api(tags = "订单接口")
@RestController
@RequestMapping("/api/order")
public class OrderController {
    @Resource
    IOrderService orderService;
    @Resource
    IPurchaseTaskService purchaseTaskService;

    @ApiOperation("oms推送订单")
    @PostMapping("/publishOrder")
    public BaseResult<Void> publishOrder(@RequestBody @Validated(value = OrderValidGroup.PublishOrder.class) Order order) {
        try {
            orderService.publishOrder(order);
        } catch (DuplicateKeyException ex) {
            throw new BizRuntimeException(ErrorCode.OR_10003);
        }
        return BaseResult.success();
    }

    @ApiOperation("oms退款完成推送到ana-order")
    @PostMapping("/orderSalesRefund")
    public BaseResult<Void> refundOrder(@RequestBody RefundOrderRequest request) {
        orderService.orderSalesRefund(request);
        return BaseResult.success();
    }

    @ApiOperation("发起采购")
    @GetMapping("/purchase")
    public BaseResult<Void> purchase(@RequestParam String id) {
        OrderIdLock lock = OrderIdLock.getInstance();
        long idLong = Long.parseLong(id);
        try {
            lock.lock(idLong);
            orderService.purchase(id);
            return BaseResult.success();
        } finally {
            lock.unlock(idLong);
        }
    }

    @ApiOperation("查询订单列表")
    @PostMapping("/queryPage")
    public BaseResult<Page<Order>> queryPage(@RequestBody OrderQueryPageRequest request) {
        Page<Order> page = orderService.queryPage(request);
        return BaseResult.success(page);
    }

    @GetMapping("/查询订单详情")
    @ApiOperation("查询订单详情")
    public BaseResult<Order> queryDetail(@RequestParam String id) {
        Order order = orderService.queryDetail(id);
        return BaseResult.success(order);
    }
}
